#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "levels/hmc/header.h"
#include "levels/bbh/header.h"

extern u8 _hmc_segment_ESegmentRomStart[];
extern u8 _hmc_segment_ESegmentRomEnd[];

const LevelScript level_hmc_entry[] = {
INIT_LEVEL(),
LOAD_MIO0(0x07, _bbh_segment_7SegmentRomStart, _bbh_segment_7SegmentRomEnd),
LOAD_RAW(0x1A, _bbhSegmentRomStart, _bbhSegmentRomEnd),
LOAD_RAW(0x0E, _hmc_segment_ESegmentRomStart, _hmc_segment_ESegmentRomEnd),
LOAD_MIO0(0xA, _water_skybox_mio0SegmentRomStart, _water_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group1_mio0SegmentRomStart, _group1_mio0SegmentRomEnd),
LOAD_RAW(12, _group1_geoSegmentRomStart, _group1_geoSegmentRomEnd),
LOAD_MIO0(6, _group17_mio0SegmentRomStart, _group17_mio0SegmentRomEnd),
LOAD_RAW(13, _group17_geoSegmentRomStart, _group17_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Level Specific Models
LOAD_MODEL_FROM_GEO(MODEL_BBH_HAUNTED_DOOR,           haunted_door_geo),
LOAD_MODEL_FROM_GEO(MODEL_BBH_STAIRCASE_STEP,         geo_bbh_0005B0),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TILTING_FLOOR_PLATFORM, geo_bbh_0005C8),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TUMBLING_PLATFORM,      geo_bbh_0005E0),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TUMBLING_PLATFORM_PART, geo_bbh_0005F8),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MOVING_BOOKSHELF,       geo_bbh_000610),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MESH_ELEVATOR,          geo_bbh_000628),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MERRY_GO_ROUND,         geo_bbh_000640),
LOAD_MODEL_FROM_GEO(MODEL_BBH_WOODEN_TOMB,            geo_bbh_000658),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_2),
JUMP_LINK(script_func_global_18),
JUMP_LINK(local_area_hmc_1_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 0, /* pos */ 0, 0, 0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_hmc_1_[] = {
AREA(1, Geo_hmc_1_0x15192a0),
TERRAIN(col_hmc_1_0xe03e7a0),
SET_BACKGROUND_MUSIC(0, 40),
TERRAIN_TYPE(0),
JUMP_LINK(local_objects_hmc_1_),
JUMP_LINK(local_warps_hmc_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_hmc_1_[] = {
OBJECT_WITH_ACTS(0, -5788, 1049, 6044, 0, 90, 0, 0xa0000,  bhvSpinAirborneWarp, 31),
OBJECT_WITH_ACTS(0, -2446, 4951, -1250, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(122, -2637, 1860, -3402, 0, -90, 0, 0x2000000,  bhvStar, 31),
OBJECT_WITH_ACTS(38, -3007, 1726, -3395, 0, 90, 0, 0x11000000,  bhvDoor, 31),
OBJECT_WITH_ACTS(122, -123, 1950, 3083, 0, 0, 0, 0x0,  bhvStar, 31),
OBJECT_WITH_ACTS(0, 5217, 6964, -5965, 0, 0, 0, 0x4000000,  bhvHiddenStar, 31),
OBJECT_WITH_ACTS(122, -357, 3746, -1362, 0, 0, 0, 0x1000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, 5225, 8461, 3085, 0, 0, 0, 0x3000000,  bhvStar, 31),
OBJECT_WITH_ACTS(0, -5693, 6000, 3084, 180, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(140, -5696, 5871, 3084, 0, 0, 0, 0x0,  bhvBlueCoinSwitch, 31),
OBJECT_WITH_ACTS(118, -6001, 5869, 3083, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -5385, 5869, 3083, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(0, -5665, 6332, -5953, 180, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(140, -5672, 6201, -5962, 0, 0, 0, 0x0,  bhvBlueCoinSwitch, 31),
OBJECT_WITH_ACTS(118, -5298, 5692, -4808, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -6136, 5138, -4814, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -5722, 4617, -4814, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -5298, 4081, -4808, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(140, 5226, 5106, -5942, 0, 0, 0, 0x0,  bhvBlueCoinSwitch, 31),
OBJECT_WITH_ACTS(0, 5202, 5238, -5932, 180, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(118, 5234, 5255, -6745, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 5234, 3660, -6745, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 5234, 2032, -6745, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(0, 3506, 1056, -1329, 180, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(140, 3497, 925, -1340, 0, 0, 0, 0x0,  bhvBlueCoinSwitch, 31),
OBJECT_WITH_ACTS(118, 3503, 1450, -1331, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 3490, 521, -1347, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(140, 5195, 6047, 3074, 0, 0, 0, 0x0,  bhvBlueCoinSwitch, 31),
OBJECT_WITH_ACTS(0, 5209, 6175, 3084, 180, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(118, 5200, 6700, 1000, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 5200, 6700, -1000, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(137, -2489, 4200, 1109, 0, 0, 0, 0x20000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, -2500, 5300, -270, 0, 0, 0, 0x0,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, 3490, -917, -1348, 0, 0, 0, 0x5000000,  bhvHiddenRedCoinStar, 31),
OBJECT_WITH_ACTS(215, -153, 930, 3085, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -1916, 3780, -1124, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -4527, 4723, -5953, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 5221, 2520, 3074, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 6014, 2670, -5948, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -178, 1800, -6537, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 1548, 2310, -1357, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -2470, 3420, -3267, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(0, -194, 2007, -5956, -3, 90, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 5258, 2187, -1331, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -5724, 2187, -1602, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(120, -141, 120, 3079, 0, 0, 0, 0x0,  bhvRecoveryHeart, 31),
OBJECT_WITH_ACTS(89, -212, 1500, 3099, 0, 0, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(89, 3999, 3295, -3276, 0, 0, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(180, -3346, 5642, -3951, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, -4206, 6154, -4720, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(206, -2505, 2580, 3009, 0, 0, 0, 0x0,  bhvSnufit, 31),
OBJECT_WITH_ACTS(206, 2084, 2580, 3009, 0, 0, 0, 0x0,  bhvSnufit, 31),
OBJECT_WITH_ACTS(206, 1564, 2130, 520, 0, 0, 0, 0x0,  bhvSnufit, 31),
OBJECT_WITH_ACTS(206, 3097, 2422, -5927, 0, 0, 0, 0x0,  bhvSnufit, 31),
OBJECT_WITH_ACTS(223, -2486, 150, -4916, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(89, -2557, 4915, -3213, 0, 0, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(188, 3571, 120, 1608, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, -1426, 3360, 1227, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(89, 821, 3405, -394, 0, 180, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(223, -5306, 3386, -3745, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(122, -359, 3600, -1365, 0, 0, 0, 0x0,  bhvSnufit, 31),
OBJECT_WITH_ACTS(122, -359, 3900, -1365, 0, 0, 0, 0x0,  bhvSnufit, 31),
OBJECT_WITH_ACTS(101, 1590, 1830, -3286, 0, 0, 0, 0x0,  bhvScuttlebug, 31),
OBJECT_WITH_ACTS(122, -4160, 210, 6040, 0, 270, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(124, -4552, 30, 6040, 0, 270, 0, 0x3c0000,  bhvMessagePanel, 31),
OBJECT_WITH_ACTS(137, -2489, 3650, 1109, 0, 0, 0, 0x70000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, 5217, 6590, -5964, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(124, -3059, 1734, -3230, 0, 270, 0, 0x3d0000,  bhvMessagePanel, 31),
OBJECT_WITH_ACTS(217, -5694, 5869, 3083, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(217, -6001, 5869, 3083, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(217, -5385, 5869, 3083, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(217, 5860, 6420, -5621, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(217, 5551, 6420, -5308, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(217, 5860, 6720, -5309, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(217, 5860, 6420, -5308, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(180, 4329, 7700, 2187, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 6111, 7701, 2182, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 4327, 7700, 3987, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 6127, 7699, 3983, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(212, 2770, 132, 6265, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(101, -1433, 120, 1250, 0, 0, 0, 0x0,  bhvScuttlebug, 31),
OBJECT_WITH_ACTS(220, 2699, 570, -1379, 0, 0, 0, 0x0,  bhvFlyGuy, 31),
OBJECT_WITH_ACTS(212, 1527, 1230, -1331, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(129, 5248, 2036, -3310, 0, 0, 0, 0x0,  bhvJumpingBox, 31),
OBJECT_WITH_ACTS(188, 2992, 120, -4655, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(101, -3345, 1504, -2905, 0, 0, 0, 0x0,  bhvScuttlebug, 31),
OBJECT_WITH_ACTS(0, -4111, 360, -407, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(137, -3349, 859, -3896, 0, 0, 0, 0x50000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(188, -367, 120, 5866, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, 4259, 120, -1290, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(89, -4105, 840, 1776, 0, 0, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(0, 6001, 4384, -5970, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(194, 1516, 3540, -3235, 0, 0, 0, 0x0,  bhvCirclingAmp, 31),
OBJECT_WITH_ACTS(122, -359, 208, -1365, 0, 0, 0, 0x0,  bhvCirclingAmp, 31),
OBJECT_WITH_ACTS(212, -2986, 3874, -1116, 0, 0, 0, 0x0,  bhv1Up, 31),
OBJECT_WITH_ACTS(0, 5733, 390, 5909, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(0, 3904, 780, 5110, 0, 0, 0, 0x120000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(101, -5733, 2094, -4449, 0, 0, 0, 0x0,  bhvScuttlebug, 31),
OBJECT_WITH_ACTS(0, 6033, 1004, -5965, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 3120, 2460, -4736, 0, 0, 0, 0x1000000,  bhvCheckerboardElevatorGroup, 31),
RETURN()
};

const LevelScript local_warps_hmc_1_[] = {
WARP_NODE(10, 9, 1, 0, 0),
WARP_NODE(240, 6, 1, 46, 0),
WARP_NODE(241, 6, 1, 56, 0),
RETURN()
};
